/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.menu;

import java.util.EnumSet;
import java.util.Set;
import mod.traister101.sns.common.menu.SNSMenus;
import mod.trasiter101.esc.common.capability.ExtendedSlotCapacityHandler;
import mod.trasiter101.esc.common.menu.ExtendedSlotCapacityMenu;
import mod.trasiter101.esc.common.slot.ExtendedSlotItemHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class ContainerItemMenu
extends ExtendedSlotCapacityMenu {
    private static final Set<ClickType> ILLEGAL_ITEM_CLICKS = EnumSet.of(ClickType.QUICK_MOVE, ClickType.PICKUP, ClickType.THROW, ClickType.SWAP);
    protected final Player player;
    protected final InteractionHand hand;
    protected final int heldItemIndex;
    protected final IItemHandler handler;
    protected int itemIndex;

    public ContainerItemMenu(int windowId, Inventory inventory, IItemHandler handler, InteractionHand hand, int hotbarSlot) {
        super((MenuType)SNSMenus.SACK_MENU.get(), windowId, handler.getSlots());
        this.player = inventory.f_35978_;
        this.hand = hand;
        this.heldItemIndex = hotbarSlot;
        this.handler = handler;
        this.itemIndex = this.hand == InteractionHand.MAIN_HAND ? this.containerSlots + this.heldItemIndex + 27 : -100;
        this.addContainerSlots();
        this.addPlayerInventorySlots(inventory);
    }

    static ContainerItemMenu fromNetwork(int windowId, Inventory inventory, FriendlyByteBuf byteBuf) {
        InteractionHand hand = byteBuf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack heldStack = inventory.f_35978_.m_21120_(hand);
        IItemHandler itemHandler = (IItemHandler)heldStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)new ExtendedSlotCapacityHandler(byteBuf.readInt(), byteBuf.readInt()));
        return new ContainerItemMenu(windowId, inventory, itemHandler, hand, hand == InteractionHand.OFF_HAND ? -1 : inventory.f_35977_);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            if (slotIndex < this.containerSlots ? !this.m_38903_(slotStack, this.containerSlots, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.containerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            return slotStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slotIndex, int mouseButtom, ClickType clickType, Player player) {
        if (slotIndex == this.itemIndex && ILLEGAL_ITEM_CLICKS.contains(clickType)) {
            return;
        }
        if (mouseButtom == this.heldItemIndex && clickType == ClickType.SWAP) {
            return;
        }
        if (mouseButtom == 40 && clickType == ClickType.SWAP && this.hand == InteractionHand.OFF_HAND) {
            return;
        }
        super.m_150399_(slotIndex, mouseButtom, clickType, player);
    }

    public boolean m_6875_(Player player) {
        return !(this.hand == InteractionHand.MAIN_HAND ? ((Slot)this.f_38839_.get(this.itemIndex)).m_7993_() : this.player.m_21206_()).m_41619_();
    }

    protected void addContainerSlots() {
        switch (this.containerSlots) {
            case 1: {
                this.addSlots(1, 1, 80, 32);
                break;
            }
            case 4: {
                this.addSlots(2, 2, 71, 23);
                break;
            }
            case 8: {
                this.addSlots(2, 4, 53, 23);
                break;
            }
            case 18: {
                this.addSlots(2, 9, 8, 23);
                break;
            }
            default: {
                int rows = Math.round((float)this.containerSlots / 9.0f);
                int columns = this.containerSlots / rows;
                this.addSlots(rows, columns);
            }
        }
    }

    private void addSlots(int rows, int columns, int startX, int startY) {
        assert (rows != 0) : "Cannot have zero rows of slots";
        assert (columns != 0) : "Cannot have zero columns of slots";
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                int yPosition = startY + row * 18;
                int xPosition = startX + column * 18;
                int index = column + row * columns;
                this.m_38897_((Slot)new ExtendedSlotItemHandler(this.handler, index, xPosition, yPosition));
            }
        }
    }

    private void addSlots(int rows, int columns) {
        if (rows > 1) {
            this.addSlots(rows - 1, 9, 8, 18);
        }
        for (int column = 0; column < columns; ++column) {
            int yPosition = 18 * (rows - 1) + 18;
            int xPosition = 8 + column * 18;
            int index = column + (rows - 1) * columns;
            this.m_38897_((Slot)new ExtendedSlotItemHandler(this.handler, index, xPosition, yPosition));
        }
    }

    protected final void addPlayerInventorySlots(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
    }
}

